# EXEMPLE SERVO MOTEUR - MESURES avec ARDUINO-PYTHON - ROUX Anthony - 2020

# -*- coding: utf-8 -*-

from py2duino import *                              # Pour travailler avec des Arduinos
import time        
import os                  
import matplotlib.pyplot as plt
import numpy as np
from threading import Thread                        # Pour faire du multitache

os.chdir('C:\\Users\\Anthony\\Documents\\CPGE')     # Définition du répertoire de travail  !!!!!!!!!! A MODIFIER !!!!!!!!!!!!!!

COM_ARDUINO      = 8      # COM sur lequel est branché l'arduino   !!!!!!!!!! A MODIFIER !!!!!!!!!!!!!!
pin_Servo        = 9      # Branchement du servo moteur sur le pin 9

temps = [0]              # Initialisation liste des temps
valPos = [0]             # Initialisation liste des positions du servo moteur

##

print("\n\n")
print("########################################################")
print("####   ACQUISITIONS DES MESURES SUR LE SERVO MOTEUR ####")
print("########################################################")
print("#################################################A.Roux#")
print("\n\n")

MaCarte=Arduino(COM_ARDUINO,baudrate=115200)     # Amorce la commmunication par le port série avec Arduino
time.sleep(1)                                    # On attend 1s pour que la communication s'établisse bien !

# Déclaration des broches E/S Analogiques   ## SI BESOIN POUR D'AUTRES EXPERIENCES
# VCC         = AnalogInput(MaCarte,pin_VCC)      # ou AnalogOutput(MaCarte,pin_VCC)    # Selon le besoin

# Déclaration des broches E/S Digitales     ## SI BESOIN POUR D'AUTRES EXPERIENCES
# V_mot       = DigitalOutput(MaCarte,pin_Servo)  # ou DigitalInput(MaCarte,pin_Servo)  # Selon le besoin               

servo=Servo(MaCarte,1)  # Définition du servomoteur

duree = 10.0                                     # Durée totale de chaque acquisition (en secondes)

def attente():
    mot=0
    while mot==0:
        print("\nLe Servo-moteur est-il installé ? (répondre : OK)\n")
        sol=input()
        if sol=='OK' :
            print('##################################################')
            print('### Début des acquisitions pour le servo-moteur ##')
            print('##################################################')
            mot=1
        else:
            print('Veuillez brancher le servo-moteur et répondre OK')

def graphique():
    global duree
    plt.clf()
    
    plt.figure(1)
    plt.xlim(0,duree)
    plt.ylim(0,190)
    plt.ylabel("Angle (en deg)")
    plt.xlabel("Temps (en s)")
    plt.grid()
    plt.title("Acquisition ANGLE du servo-moteur en fonction du temps")
    plt.plot(-1,-100,'bo',label='ANGLE servo-moteur')
    plt.legend()
    plt.show()
    
    i=0
    while (time.time()-start <duree):
      plt.figure(1)
      plt.plot(temps[-1],valPos[-1],'bo')
      plt.pause(0.001) 
      i+=1
    time.sleep(0.1)
    print("Nb de points du graph : ", i) 
    return None    

## ========= THREAD de stockage des données  ============= ##

def donnee():                                  # Enregistre les données en local puis sur un fichier
    pos=0            
    dureetemps= start 
    while time.time()-start <duree:             # Boucle d'acquisition sans pause
        dureetemps=time.time() - dureetemps
        temps.append(time.time()-start)
        servo.write(pos)
        valPos.append(pos)
        if pos==180: # Inversion du sens de rotation à 180°
            max=1
        if pos==0:   # Inversion du sens de rotation à 0°
            max=0
        if max==0:   # Augmentation de la position jusqu'à 180°
            pos=pos+1
        if max==1:   # Diminution de la position jusqu'à 0°
            pos=pos-1
        time.sleep(0.001) # Temps entre chaque mesure
    f=open('Mesure_position_Servo_Moteur.csv',"w")
    for i in range(1,len(temps)) :
        f.write(str(temps[i]) + " " + str(valPos[i]) + '\n') # Sur une même ligne, les variables sont séparées par des espaces !
    f.close()
      
## ========= Programme Principal ============= ##

attente()                               # Attente de l'installation du servo-moteur par l'utilisateur
start = time.time() 
t1 = Thread(target=donnee)              # Defini la fonction 'donnee' comme threat ou tache
t1.setDaemon(True)                      # Tache-> Daemon pour etre certain qu'elle s'arrete lorsque le prog principal s'arrete
t1.start()                              # Active la tache
graphique()                             # Trace les données

print('##################################################')
print('### Fin des acquisitions pour le servo-moteur ####')
print('##################################################')

MaCarte.close()                         # On libère la carte Arduino

print('####################################')
print('### Fin du programme de mesures ####')
print('####################################')