# EXEMPLE SERVO MOTEUR - TRAITEMENT DES DONNEES - ROUX Anthony - 2020

# -*-coding:Utf-8 -*

###########################
# Importation des modules #
###########################

import os
import numpy as np
import matplotlib.pyplot as plt

os.chdir('C:\\Users\\Anthony\\Documents\\CPGE') # Définition du répertoire de travail   !!!!!!!!!! A MODIFIER !!!!!!!!!!!!!!

## Importation des résultats

dataCsv=np.loadtxt('Mesure_position_Servo_Moteur.csv', skiprows=0,delimiter=' ') # Les variables sont séparées par des espaces !
Temps=[dataCsv[i][0] for i in range(len(dataCsv))] # Temps
POS=[dataCsv[i][1] for i in range(len(dataCsv))]   # Position

## Définition et calcul de la vitesse en deg/s

VIT=[0]
for i in range(len(POS)-1):
    VIT.append((POS[i+1]-POS[i])/(Temps[i+1]-Temps[i]))

## Linéarisation de la vitesse

indp=[]
indm=[]

for i in range(len(POS)-1):
    if (POS[i+1]-POS[i])>0: # On note les indices pour POS croissant
        indp.append(i)
    else:                   # On note les indices pour POS décroissant
        indm.append(i)

MEANpVIT=np.mean([VIT[i] for i in indp]) # On note la valeur moyenne pour les valeurs positives
MEANmVIT=np.mean([VIT[i] for i in indm]) # On note la valeur moyenne pour les valeurs négatives
Valeur_moy_VIT=np.zeros(len(POS))        # Initialisation à 0 

for i in indp:
    Valeur_moy_VIT[i]=MEANpVIT
for i in indm:
    Valeur_moy_VIT[i]=MEANmVIT

## Tracé des figures

plt.figure(1)
plt.xlim(0,Temps[len(Temps)-1])
plt.ylim(-100,190)
plt.ylabel("Angle (en deg) & Vitesse (en deg/s)")
plt.xlabel("Temps (en s)")
plt.grid()
plt.title("Acquisition ANGLE du servo-moteur en fonction du temps")
plt.plot(Temps,POS,'b-',label='ANGLE servo-moteur')
plt.plot(Temps,VIT,'r-',label='VITESSE servo-moteur')
plt.plot(Temps,Valeur_moy_VIT,'ro',label='VITESSE MOYENNE servo-moteur')
plt.legend()
plt.show()